//---------------------------------------------------------------
// Fichero:  enunciado09.asy
// Objetivo: Representar el enunciado 9
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,-2.5), B=(5,0), C=(0,2.5), D=(-5,0);

// Los ángulos
markangle("$\alpha$", radius=6mm, C, B, A, 0.5bp+blue);
markangle(Ang(D,A,B,0), radius=3mm, B, A, D, 0.5bp+blue);
markangle(Ang(B,C,D,0), radius=3mm, D, C, B, 0.5bp+blue);
markangle("$\alpha$", radius=6mm, A, D, C, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
