//---------------------------------------------------------------
// Fichero:  enunciado05.asy
// Objetivo: Representar el enunciado 5
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(4,0), B=(2,3), C=(-2,3), D=(-4,0);

// Los ángulos
markangle("$\alpha$", radius=3mm, C, B, A, 0.5bp+blue);
markangle(Ang(D,A,B,0), radius=5mm, B, A, D, 0.5bp+blue);
markangle("$\alpha$", radius=3mm, D, C, B, 0.5bp+blue);
markangle(Ang(C,D,A,0), radius=5mm, A, D, C, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
