//---------------------------------------------------------------
// Fichero:  trapecioisosceles1.asy
// Objetivo: Ejercicio sobre trapecio isósceles
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(-128,0), B=(128,0), C=(50,160), D=(-50,160);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label(Dist(D,A), (D+A)/2, NW, blue);
label(Dist(B,C), (B+C)/2, NE, blue);
