//---------------------------------------------------------------
// Fichero:  rombo1.asy
// Objetivo: Ejercicio sobre rombo
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Semidiagonales del rombo
real d=80, g=39;

// Los vértices del rombo
pair A=(0,g), B=(d,0), C=(0,-g), D=(-d,0);

// El rombo
draw(A -- B -- C -- D -- cycle);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=2, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- B, FormExt);
draw(B -- C, FormExt);
draw(C -- D, FormExt);
draw(D -- A, FormExt);

// Las flechas que marcan las dimensiones
real Separacion=4;
draw((-d,-g-Separacion) -- (d,-g-Separacion), blue, Arrows(HookHead,5bp));
draw(shift(5,0)*((d,-g) -- (d,g)), blue, Arrows(HookHead,5bp));

// Los textos
label(string(2*d), 1.2*(0,-g-Separacion), blue);
label(string(2*g), (1.3*d,0), blue);
