//---------------------------------------------------------------
// Fichero:  paralelogramo2.asy
// Objetivo: Ejercicio sobre paralelogramo
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Grosor de las líneas
defaultpen(1);

// El giro
transform r=rotate(60);

// Los vértices
pair A=(0,0), B=r*(15,0), D=r*(10,22), C=B+(D-A);

// La altura
pair P=D+0.2*(C-D);
pair Q=extension(A, B, P, P+Perpendicular(A,B));
draw(P -- Q, heavygray);
markrightangle(D, P, Q, 0.5bp+gray);
markrightangle(A, Q, P, 0.5bp+gray);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, SE, blue);
label(Dist(B,C), (B+C)/2, NE, blue);
label(Dist(P,Q), (P+Q)/2, 1.5*N, blue);
