//---------------------------------------------------------------
// Fichero:  cuadrado1.asy
// Objetivo: Ejercicio sobre cuadrado
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(3,0), C=(3,3), D=(0,3);

// Los ángulos rectos
markrightangle(D, A, B, 0.5bp+gray);
markrightangle(C, B, A, 0.5bp+gray);
markrightangle(D, C, B, 0.5bp+gray);
markrightangle(C, D, A, 0.5bp+gray);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=2, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- B, FormExt);
draw(B -- C, FormExt);
draw(C -- D, FormExt);
draw(D -- A, FormExt);

// Las medidas
label("31", (A+B)/2, 2*S, blue);
