//---------------------------------------------------------------
// Fichero:  rectangulo1.asy
// Objetivo: Ejercicio sobre rectángulo
// Fecha:    L.7.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,0), C=(5,3), D=(0,3);

// Los ángulos rectos
markrightangle(D, A, B, 0.5bp+gray);
markrightangle(C, B, A, 0.5bp+gray);
markrightangle(D, C, B, 0.5bp+gray);
markrightangle(C, D, A, 0.5bp+gray);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Las medidas
label("19", (A+B)/2, S, blue);
label("11", (B+C)/2, E, blue);
