//---------------------------------------------------------------
// Fichero:  símbolos.asy
// Objetivo: Representar con símbolos un arco y sus datos
// Fecha:    D.4.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los ángulos que definen los puntos de la circunferencia
real Ini=-50, Fin=60, Med=(Ini+Fin)/2;

// El centro y dos puntos de la circunferencia
pair T=(0,0), A=(Cos(Ini),Sin(Ini)), B=(Cos(Fin),Sin(Fin));

// El ángulo
markangle("$\alpha$", radius=4mm, A, T, B, 1bp+black);

// La circunferencia
draw(circle(T,1));

// El arco
draw(arc(T, 1, Ini, Fin), 2bp+blue);

// Los puntos
dot(T, 3bp+black);
dot(A, 3bp+black);
dot(B, 3bp+black);

// Los radios
draw(A -- T -- B);

// Los textos
real Separacion=0.12;
label("$a$", (Cos(Med),Sin(Med)), E, black);
label("$r$", (T+A)/2+Separacion*(A.y,-A.x), black);
label("$r$", (T+B)/2-Separacion*(B.y,-B.x), black);
