//---------------------------------------------------------------
// Fichero:  regular32.asy
// Objetivo: Representar un polígono regular de 32 lados
// Fecha:    S.3.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Poligono = polygon(32);
draw(Poligono);

// Los puntos
pair T=(0,0), P=point(Poligono,0), M=(P+point(Poligono,1))/2;

// El radio
draw(T -- P, blue);

// La apotema
draw(T -- M, red);

// Los puntos
dot(T, 3bp+black);
dot(P, 3bp+black);
dot(M, 3bp+black);
