//---------------------------------------------------------------
// Fichero:  inscrito.asy
// Objetivo: Representar un ángulo inscrito
// Fecha:    V.2.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// Puntos de la circunferencia
pair V=(Cos(-40),Sin(-40)), A=(Cos(90),Sin(90)), B=(Cos(200),Sin(200));

// La marca del ángulo
markangle(radius=4mm,A,V,B,4bp+blue+squarecap);

// La circunferencia
draw(circle(T,1));

// Los lados del ańgulo
draw(V -- A+0.1*(A-V));
draw(V -- B+0.1*(B-V));

// Los puntos
dot(V,3bp+red);
dot(A,3bp+red);
dot(B,3bp+red);
