//---------------------------------------------------------------
// Fichero:  sector2.asy
// Objetivo: Representar otro sector circular
// Fecha:    J.1.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// Extremos de la cuerda
pair A=(Cos(40),Sin(40)), B=(Cos(100),Sin(100));

// La circunferencia
draw(circle(T,1));

// El sector
filldraw(T -- A -- arc((0,0),A,B,CW) -- cycle, gray);

// El centro
dot(T,3bp+black);
