//---------------------------------------------------------------
// Fichero:  propiedadexteriores.asy
// Objetivo: Propiedad de dos circunferencias exteriores
// Fecha:    X.30.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.4cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta de tamaño determinado
Label Eti(string Texto, pen Color)
    { return Label(Texto,fontsize(6pt)+Color); }

// Definición de los centros y los radios
pair T1=(0,0), T2=(3,0);
real R1=1, R2=1.2;

// Definición de puntos de las circunferencias
pair P1=(Cos(33),Sin(33)), P2=T2+R2*(Cos(145),Sin(145));

// Las circunferencias
draw(circle(T1,R1));
draw(circle(T2,R2));

// Los radios
draw(T1 -- P1, blue);
label(Eti("$s$", blue), (T1+P1)/2, NW, blue);
draw(T2 -- P2, blue);
label(Eti("$r$", blue), (T2+P2)/2, NE, blue);

// La distancia
draw(T1 -- T2, red);
label(Eti("$d$", red), (T1+T2)/2, S, red);

// Los puntos
dot(T1, 3bp+black);
dot(T2, 3bp+black);
dot(P1, 3bp+black);
dot(P2, 3bp+black);
