//---------------------------------------------------------------
// Fichero:  tangentes.asy
// Objetivo: Recta y circunferencia tangentes
// Fecha:    M.29.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición del centro y el punto de tangencia
pair T=(0,0), G=(Cos(155), Sin(155));

// Dos puntos de la recta
pair A=G+(-G.y,G.x), B=G+(G.y,-G.x);

// La circunferencia
draw(circle(T,1));

// La recta
draw(A -- B);

// El punto
dot(G, 3bp+blue);
