//---------------------------------------------------------------
// Fichero:  propiedadsecantes.asy
// Objetivo: Propiedad recta y circunferencia secantes
// Fecha:    M.29.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Definición del centro y un punto de la circunferencia
pair T=(0,0), G=(Cos(33),Sin(33));

// Definición de dos puntos de la recta
pair A=(-0.8,-1.1), B=(-0.4,1.1);

// La circunferencia
draw(circle(T,1));

// El radio
draw(T -- G, blue);
label("$r$", (T+G)/2, NW, blue);

// La recta
draw(A -- B);

// La distancia entre la recta y el centro de la circunferencia
pair Q=extension(A, B, T, T+Perpendicular(A,B));
draw(T -- Q, red);
label("$d$", (T+Q)/2, S, red);

// Marcamos el ángulo recto
markrightangle(T, Q, B, 2mm, gray);

// Los puntos
dot(T, 3bp+black);
dot(G, 3bp+black);
dot(Q, 3bp+black);
