//---------------------------------------------------------------
// Fichero:  enunciado3.asy
// Objetivo: Enunciado 3
// Fecha:    M.6.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// El centro de la circunferencia
pair T=(0,0);

// Dos puntos de tangencia
pair A=(Cos(-90),Sin(-90)), B=(Cos(180),Sin(180));

// Un punto de la circunferencia
pair V=(Cos(22),Sin(22));

// El punto exterior
pair Q=extension(A, A+Perpendicular(T,A), B, B+Perpendicular(T,B));

// Los ángulos
markrightangle(A, Q, B, 4mm, blue);
markangle("$\alpha$", radius=10mm, B, V, A, blue);

// La circunferencia
draw(circle(T,1));

// El ángulo
draw(A -- V -- B);

// Los puntos
dot(T, 3bp+black);
dot(A, 3bp+black);
dot(B, 3bp+black);

// Las rectas
pair Sep=0.1*(A-Q);
draw(A+4*Sep -- Q-Sep);
pair Sep=0.1*(B-Q);
draw(B+4*Sep -- Q-Sep);
