//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Representar la solución 2
// Fecha:    L.26.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los extremos de las rectas
pair R1=(-2,0.3), R2=(2,0.3);
pair S1=(-2,-0.3), S2=(2,-0.3);
pair T1=(-1.8,-0.7), T2=(1.8,0.7);

// Definimos las rectas
path r = R1 -- R2;
path s = S1 -- S2;
path t = T1 -- T2;

// Los vértices
pair VR=intersectionpoint(r,t);
pair VS=intersectionpoint(s,t);

// Los ángulos
markangle("$25^\circ$", radius=10mm, R2, VR, T2, 0.5bp+blue);
markangle("$\beta$", radius=10mm, S2, VS, T2, 0.5bp+blue);
markangle("$\alpha$", radius=3mm, T2, VS, S1, 0.5bp+blue);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);
