//---------------------------------------------------------------
// Fichero:  alternosinternos2.asy
// Objetivo: Representar ángulos alternos internos
// Fecha:    D.25.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Los extremos de las rectas
pair R1=(-2,0.75), R2=(2,0.75);
pair S1=(-2,-0.75), S2=(2,-0.75);
pair T1=(-1.8,-1.1), T2=(1.8,1.1);

// Definimos las rectas
path r = R1 -- R2;
path s = S1 -- S2;
path t = T1 -- T2;

// Los vértices
pair VR=intersectionpoint(r,t);
pair VS=intersectionpoint(s,t);

// Los ángulos
markangle("$\beta$", radius=5mm, T1, VR, R2, 0.5bp+blue);
markangle("$\beta$", radius=5mm, T2, VS, S1, 0.5bp+blue);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);
label("$r$", R1, W);
label("$s$", S1, W);
label("$t$", (0,0), NW);
