//---------------------------------------------------------------
// Fichero:  paralelos2.asy
// Objetivo: Representar ángulos obtusos de lados paralelos
// Fecha:    D.25.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El desplazamiento de una figura a otra
pair Desplazamiento = (0.5,-1.5);

// Los vértices
pair V1=(0,0), V2=shift(Desplazamiento)*V1;

// Los extremos de las rectas
pair R1=(2,0), S1=(-2,1);
pair R2=shift(Desplazamiento)*R1, S2=shift(Desplazamiento)*S1;

// Los ángulos
markangle("$\beta$", radius=5mm, R1, V1, S1, 0.5bp+blue);
markangle("$\beta$", radius=5mm, R2, V2, S2, 0.5bp+blue);

// Dibujamos las rectas
draw(S1 -- V1 -- R1);
draw(S2 -- V2 -- R2);
