//---------------------------------------------------------------
// Fichero:  angulo40.asy
// Objetivo: Representar un ángulo de 40°
// Fecha:    V.23.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (0.25*Cos(angulo),0.25*Sin(angulo)); }

// Los extremos de los lados
pair L1=PuntoCir(0), L2=PuntoCir(40);

// La marca del ángulo
markangle("$40^\circ$", radius=6mm, L1, V, L2, 0.5bp+black);

// Dibujamos los lados
draw(L1 -- V -- L2);

// Marcamos el vértice
dot(V, 4bp+black);

// Los nombres de los lados
label("$r$", L1, E);
label("$s$", L2, E);
