//---------------------------------------------------------------
// Fichero:  mismabisectriz.asy
// Objetivo: Representar dos ángulos con la misma bisectriz
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos de los lados
pair L1 = (1,0.7);
pair L2 = (1,-0.7);

// Dibujamos la bisectriz
draw((-0.4,0) -- (1.1,0), gray);
label("$r$", (1.1,0), E);

// Marcamos el vértice
dot(V, 4bp+black);

// El ángulo pequeño
markangle(n=2,radius=6mm,L2,V,L1, 0.5bp+red);
label("$\alpha$", (0.4,0.1), red);

// El ángulo grande
markangle(n=1,radius=3mm,L1,V,L2, 0.5bp+blue);
label("$\beta$", (-0.2,0.1), blue);

// Dibujamos los lados
draw(L1 -- V -- L2);
label("$a$", L1, E);
label("$b$", L2, E);
