//---------------------------------------------------------------
// Fichero:  contiguos.asy
// Objetivo: Representar dos ángulos contiguos
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (0.5*Cos(angulo),0.5*Sin(angulo)); }

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos
pair A=PuntoCir(40), B=PuntoCir(10), C=PuntoCir(-30);

// Los ángulos
markangle("$\alpha$", radius=5mm, B, V, A, 0.5bp+black);
markangle("$\beta$", radius=7mm, C, V, B, 0.5bp+black);

// Dibujamos los lados
draw(V -- A);
draw(V -- B);
draw(V -- C);

// Marcamos el vértice
dot(V, 4bp+black);
