//---------------------------------------------------------------
// Fichero:  dosnombres.asy
// Objetivo: Representar dos ángulos con nombres
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos de los lados
pair L1 = (1,0.7);
pair L2 = (1,-0.7);

// El ángulo pequeño
markangle("$\alpha$",n=2,radius=6mm,L2,V,L1, 0.5bp+black);

// El ángulo grande
markangle("$\beta$",n=1,radius=3mm,L1,V,L2, 0.5bp+black);

// Dibujamos los lados
draw(V -- L1);
draw(V -- L2);

// Marcamos el vértice
dot(V, 4bp+black);
