//---------------------------------------------------------------
// Fichero:  enunciado06.asy
// Objetivo: Representar el enunciado 6
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R=PuntoCir(124);
pair S=(0.8,0);

// El vértice
pair V=(0,0);

// Los ángulos
markangle("$\alpha$", radius=4mm, R, V, S, 0.5bp+blue);
markangle("$124^\circ$", radius=3mm, S, V, R, 0.5bp+blue);

// Dibujamos las rectas
draw(V -- R);
draw(V -- S);
