//---------------------------------------------------------------
// Fichero:  enunciado05.asy
// Objetivo: Representar el enunciado 5
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=PuntoCir(41), R2=-R1;
pair S1=(1,0.5), S2=(-1,0.5);
pair T1=(1,-0.5), T2=(-1,-0.5);

// Los vértices
pair VS=intersectionpoint(R1 -- R2, S1 -- S2);
pair VT=intersectionpoint(R1 -- R2, T1 -- T2);

// Los ángulos
markangle("$\alpha$", radius=4mm, R1, VT, T2, 0.5bp+blue);
markangle("$41^\circ$", radius=6mm, S2, VS, R2, 0.5bp+blue);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);
