//---------------------------------------------------------------
// Fichero:  enunciado04.asy
// Objetivo: Representar el enunciado 4
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=PuntoCir(38), R2=-0.2*R1;
pair S1=PuntoCir(-38), S2=-0.2*S1;
pair T=(0.7,0);

// El vértice
pair V=(0,0);

// Puntos de corte
pair KR=intersectionpoint(shift(T)*rotate(90)*(3*R1 -- 3*R2), R1 -- R2);
pair KS=intersectionpoint(shift(T)*rotate(90)*(3*S1 -- 3*S2), S1 -- S2);

// Los ángulos
markangle("$\alpha$", radius=5mm, KR, T, KS, 0.5bp+blue);
markangle("$76^\circ$", radius=5mm, S1, V, R1, 0.5bp+blue);
markrightangle(T, KR, V, 4mm, gray);
markrightangle(T, KS, V, 4mm, gray);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T -- KR);
draw(T -- KS);
