//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Representar el ejemplo 3
// Fecha:    S.10.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 8, Extra = 0.2;

// Formato de marcas del eje
ticks FormatoTicks = Ticks(Label(align=W), Step=1, Size=0.5mm, pTick=blue);

// Formato de texto del eje
pen FormatoTexto = blue+fontsize(10pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las abscisas que hay que marcar
real Abs[] = {1, 4, 7};
for ( int i=0 ; i<Abs.length ; ++i )
    { dot((Abs[i],0), 4bp+red); }

// La separación entre las flechas y el objeto
real Separacion = -0.2;

// Las flechas que marcan las distancias
draw((1,Separacion) -- (4,Separacion),
     deepgreen, Arrows(HookHead,5bp), Bars(2mm));
draw((4,Separacion) -- (7,Separacion),
     deepgreen, Arrows(HookHead,5bp), Bars(2mm));

// Los textos
label("3 unidades", (2.5,2*Separacion), deepgreen+fontsize(8pt));
label("3 unidades", (5.5,2*Separacion), deepgreen+fontsize(8pt));
