//---------------------------------------------------------------
// Fichero:  fracciondefraccion.asy
// Objetivo: Representar una fracción de una fracción
// Fecha:    M.2.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca la fracción secundaria
fill(box((0,1),(5,3)), palered);

// El rectángulo que marca la fracción principal
fill(box((0,0),(5,1)), mediumgray);

// El rectángulo que marca el total
draw(box((0,0),(7,3)));

// La línea vertical
draw((5,0) -- (5,3));

// La línea horizontal
pen Punteado = linetype(new real[] {2,2});
draw((0,1) -- (5,1), Punteado);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan las fracciones
draw((-Separacion,1) -- (-Separacion,3),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-Separacion) -- (5,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las fracciones
label("Fracción del total", (2.5,-2*Separacion), fontsize(6pt));

label("Fracción", (-3*Separacion,2.3), fontsize(6pt));
label("de la", (-3*Separacion,2), fontsize(6pt));
label("fracción", (-3*Separacion,1.7), fontsize(6pt));

label("¿Fracción", (2.5,2.35), fontsize(8pt));
label("respecto", (2.5,2), fontsize(8pt));
label("al total?", (2.5,1.7), fontsize(8pt));
