//---------------------------------------------------------------
// Fichero:  paso3.asy
// Objetivo: Representar el paso 3 de un producto de fracciones
// Fecha:    M.2.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para grid()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca el numerador
fill(box((0,1),(5,3)), mediumgray);
fill(box((0,1),(5,3)), palered);

// Los cuadrados básicos
add(grid(7,3));

// El borde del numerador
draw(box((0,1),(5,3)), heavyred);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan las fracciones
draw((-Separacion,1) -- (-Separacion,3),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-Separacion) -- (5,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las fracciones
label("$\frac{5}{7}$", (2.5,-4*Separacion), fontsize(16pt));
label("$\frac{2}{3}$", (-3*Separacion,2), fontsize(16pt));
