//---------------------------------------------------------------
// Fichero:  suma.asy
// Objetivo: Representar una suma de un entero y una fracción
// Fecha:    M.2.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulito básico
real Anchura = 1;
path Rectangulo = box((0,0), (Anchura,1));

// El rectángulo grande
path RectanguloGrande = box((0,0), (4*Anchura,1));

// Las separaciones entre las representaciones de las fracciones
real SeparacionVertical = 0.2;
real SeparacionHorizontal = 5*Anchura;

// Los rectángulos que marcan los numeradores
fill(box((0,0),(3*Anchura, 1)), mediumgray);
fill(box((SeparacionHorizontal,0),(SeparacionHorizontal+3*Anchura, 1)),
          mediumgray);
fill(shift((0,1+SeparacionVertical)) * RectanguloGrande, mediumgray);
fill(shift((SeparacionHorizontal,1+SeparacionVertical)) * RectanguloGrande,
            mediumgray);
fill(shift((0,2+2*SeparacionVertical)) * RectanguloGrande, mediumgray);
fill(shift((SeparacionHorizontal,2+2*SeparacionVertical)) * RectanguloGrande,
            mediumgray);

// Los números originales van a la izquierda
for ( int i=0 ; i<4 ; ++i )
    { draw(shift(Anchura*i, 0) * Rectangulo); }
draw(shift(0, 2+2*SeparacionVertical) * RectanguloGrande);
draw(shift(0, 1+SeparacionVertical) * RectanguloGrande);

// Las representaciones de las fracciones de la derecha
for ( int i=0 ; i<3 ; ++i )
    {
    for ( int j=0 ; j<4 ; ++j )
        {
        draw(shift(SeparacionHorizontal+Anchura*j, i+i*SeparacionVertical) *
             Rectangulo);
        }
    }

// Las frechas que van desde las fracciones originales a las equivalentes
draw((4.2*Anchura,1.5+SeparacionVertical) --
     (4.8*Anchura,1.5+SeparacionVertical), deepgreen, Arrow(5bp));
draw((4.2*Anchura,2.5+2*SeparacionVertical) --
     (4.8*Anchura,2.5+2*SeparacionVertical), deepgreen, Arrow(5bp));

// Los números
label("$2$", (0,2+1.5*SeparacionVertical), W+(-3,0), fontsize(14pt));
label("$\frac{3}{4}$", (0,0.5), W, fontsize(18pt));
label("$\frac{11}{4}$", (SeparacionHorizontal+4*Anchura,1.5+SeparacionVertical),
                         E+(2,0), fontsize(18pt));

// Las flechas que engloban
draw((-0.2,1+SeparacionVertical) -- (-0.2,3+2*SeparacionVertical),
      blue, Arrows(HookHead,5bp), Bars(2mm));
draw((SeparacionHorizontal+4*Anchura+0.2,0) --
     (SeparacionHorizontal+4*Anchura+0.2,3+2*SeparacionVertical),
     blue, Arrows(HookHead,5bp), Bars(2mm));
