//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Representar en una recta ocho quintos y su opuesto
// Fecha:    J.25.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Grosor de las líneas
defaultpen(1);

// El eje horizontal
draw((-2.1,0) -- (2.1,0));

// Los números enteros
for ( int i=-2 ; i<3 ; ++i )
    {
    // Los puntos
    dot((i,0), blue);

    // El texto
    label("$" + string(i) + "$", (i,0), N+(0,1.5));
    }

// Las fracciones
dot((1.6,0), deepgreen);
dot((-1.6,0), deepgreen);
label("$\frac{8}{5}$", (1.6,0), N+(0,0.5));
label("$-\frac{8}{5}$", (-1.6,0), N+(0,0.5));

// Las flechas que indican las distancias
real Separacion = -0.1;
draw((-1.6,Separacion) -- (-0.05,Separacion), deepgreen, Arrows);
draw((1.6,Separacion) -- (0.05,Separacion), deepgreen, Arrows);
label("$\frac{8}{5}$ unidades", (-0.8,0), S+(0,-5));
label("$\frac{8}{5}$ unidades", (0.8,0), S+(0,-5));
