//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Representar en una recta los quintos de -2 a 2
// Fecha:    J.25.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Grosor de las líneas
defaultpen(1);

// El eje horizontal
draw((-2.1,0) -- (2.1,0));

// Los números enteros
for ( int i=-2 ; i<3 ; ++i )
    {
    // Los puntos
    dot((i,0), blue);

    // El texto
    label("$" + string(i) + "$", (i,0), N+(0,1.5));
    }

// Las fracciones
for ( int i=-9 ; i<10 ; ++i )
    {
    // No ponemos fracciones cuando ya hay un número entero
    if ( i%5 != 0 )
        {
        // Las líneas
        draw((i/5, -0.03) -- (i/5, 0.03), deepgreen);

        // El texto
        string Numerador = string(abs(i));
        string Signo = i<0 ? "-" : "";
        string Texto = "$" + Signo + "\frac{" + Numerador + "}{5}$";
        label(Texto, (i/5,0), N+(0,0.5));
        }
    }
