//---------------------------------------------------------------
// Fichero:  OnceSextos.asy
// Objetivo: Dibujar once sextos en dos círculos
// Fecha:    S.13.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.5cm);

// Grosor de las líneas
defaultpen(1);

// Separación entre las circunferencias
real Separacion = 2.5;

// El sector marcado
path Sector = ((0,0) -- (1,0) -- arc((0,0),1,0,60) -- cycle);

// Dibujamos seis sectores rotando
for ( int i=0 ; i<=5 ; ++i )
    { fill(rotate(60*i) * Sector, mediumgray); }

// Dibujamos cinco sectores rotando y desplazando
for ( int i=0 ; i<=4 ; ++i )
    { fill(shift(Separacion, 0) * rotate(60*i) * Sector, mediumgray); }

// La circunferencia básica
path Circunferencia = circle((0,0), 1);

// Dibujamos dos circunferencias
draw(Circunferencia, black);
draw(shift(Separacion, 0) * Circunferencia, black);

// Definimos el diámetro horizontal
path Diametro = ((-1,0) -- (1,0));

// Dibujamos tres veces el diámetro, con rotaciones
for ( int i=0 ; i<=2 ; ++i )
    { draw(rotate(60*i) * Diametro); }

// Dibujamos otras tres veces el diámetro, con rotaciones y desplazamiento
for ( int i=0 ; i<=2 ; ++i )
    { draw(shift(Separacion, 0) * rotate(60*i) * Diametro); }
