//---------------------------------------------------------------
// Fichero:  UnSexto.asy
// Objetivo: Dibujar un sexto en un círculo
// Fecha:    S.13.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2cm);

// Grosor de las líneas
defaultpen(1);

// El sector marcado
fill((0,0) -- (1,0) -- arc((0,0),1,0,60) -- cycle, mediumgray);

// Una circunferencia
draw(circle((0,0), 1), black);

// Definimos el diámetro horizontal
path Diametro = ((-1,0) -- (1,0));

// Dibujamos tres veces el diámetro, con rotaciones
draw(Diametro);
draw(rotate(60)*Diametro);
draw(rotate(120)*Diametro);
