//---------------------------------------------------------------
// Fichero:  SeisNovenos.asy
// Objetivo: Dibujar seis novenos en un cuadrado
// Fecha:    J.18.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Definimos el cuadrado pequeño
path Cuadrado = box((0,0), (1,1));

// Los cuatro cuadrados marcados
fill(shift(1, 0) * Cuadrado, mediumgray);
fill(shift(2, 1) * Cuadrado, mediumgray);
fill(shift(0, 1) * Cuadrado, mediumgray);
fill(shift(1, 2) * Cuadrado, mediumgray);

// Los cuatro triángulos marcados
fill(((0,0) -- (1,0) -- (0,1) -- cycle), mediumgray);
fill(((2,0) -- (3,0) -- (3,1) -- cycle), mediumgray);
fill(((0,2) -- (1,3) -- (0,3) -- cycle), mediumgray);
fill(((3,2) -- (3,3) -- (2,3) -- cycle), mediumgray);

// Dibujamos tres filas de tres cuadrados
for ( int i=0; i<3; ++i )
    {
    for ( int j=0 ; j<3; ++j )
        { draw(shift(i, j) * Cuadrado); }
    }
