//---------------------------------------------------------------
// Fichero:  SeisDieciseisavos.asy
// Objetivo: Dibujar seis diciseisavos en un cuadrado
// Fecha:    J.18.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Definimos el cuadrado pequeño
path Cuadrado = box((0,0), (1,1));

// Los seis cuadrados marcados
fill(shift(0, 0) * Cuadrado, mediumgray);
fill(shift(3, 0) * Cuadrado, mediumgray);
fill(shift(1, 1) * Cuadrado, mediumgray);
fill(shift(2, 1) * Cuadrado, mediumgray);
fill(shift(1, 3) * Cuadrado, mediumgray);
fill(shift(2, 3) * Cuadrado, mediumgray);

// Dibujamos cuatro filas de cuatro cuadrados
for ( int i=0; i<4; ++i )
    {
    for ( int j=0 ; j<4; ++j )
        { draw(shift(i, j) * Cuadrado); }
    }
