//---------------------------------------------------------------
// Fichero:  TreceCuartos.asy
// Objetivo: Dibujar trece cuartos con rectángulos
// Fecha:    D.14.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2cm);

// Separación entre los rectángulos
real Separacion = 0.3;

// Grosor de las líneas
defaultpen(1);

// Definimos el cuadrado pequeño
path Cuadrado = box((0,0), (1,1));

// Los cuatro cuadrados marcados
for ( int i=0; i<=3; ++i )
    {
    for ( int j=1 ; j<=3; ++j )
        { fill(shift(i, j+j*Separacion) * Cuadrado, mediumgray); }
    }
fill(Cuadrado, mediumgray);

// Dibujamos cuatro filas de cuatro cuadrados
for ( int i=0; i<=3; ++i )
    {
    for ( int j=0 ; j<=3; ++j )
        { draw(shift(i, j+j*Separacion) * Cuadrado); }
    }
