//---------------------------------------------------------------
// Fichero:  ejercicio.asy
// Objetivo: Mostrar un ejercicio resuelto
// Fecha:    X.31.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(0.8333,2.5), B=(-4.6667,2.8333), C=(-0.5,-1.3333);
pair D=(4.5,-0.3333), F=(1.5,0), G=(0,2.3333);
pair  H=(-4.1667,0), I=(0,-2.6667), J=(2.5,-1), K=(-2,0.8333);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 5, Ymin = -3, Ymax = 3, Extra = 0.1;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, step=0.1666, NoZero, Size=1mm, size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, E, 5pt+black);
dot(Label("B"), B, S, 5pt+black);
dot(Label("C"), C, S, 5pt+black);
dot(Label("D"), D, S, 5pt+black);
dot(Label("F"), F, N, 5pt+black);
dot(Label("G"), G, E, 5pt+black);
dot(Label("H"), H, N, 5pt+black);
dot(Label("I"), I, E, 5pt+black);
dot(Label("J"), J, S, 5pt+black);
dot(Label("K"), K, N, 5pt+black);
