//---------------------------------------------------------------
// Fichero:  ceros.asy
// Objetivo: Mostrar ejemplos de puntos en los ejes
// Fecha:    D.28.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos de ejemplo
pair A=(7,0), B=(-4,0), C=(0,3), D=(0,-2);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 8, Ymin = -3, Ymax = 4, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos de ejemplo
dot(Label("A=(7,0)"), A, N, 5pt+black);
dot(Label("B=$(-4,0)$"), B, N, 5pt+black);
dot(Label("C=(0,3)"), C, E, 5pt+black);
dot(Label("D=$(0,-2)$"), D, E, 5pt+black);
dot(Label("O=(0,0)"), (0,0), NE, 5pt+black);
