//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Mostrar los ejes del enunciado
// Fecha:    X.31.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -2, Ymax = 2, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, step=0.3333, NoZero, Size=1mm, size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
