//---------------------------------------------------------------
// Fichero:  solucion3.asy
// Objetivo: Resolver el ejercicio 3
// Fecha:    D.28.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Definción de los puntos
pair A=(-8,-2), B=(1,-3), C=(-2,3), D=(5,1);

// Las líneas que indican abscisa y ordenada
pen Punteado = linetype(new real[] {2,2});
draw((-8,0) -- A, Punteado+gray);
draw((0,-2) -- A, Punteado+gray);
draw((1,0) -- B, Punteado+gray);
draw((0,-3) -- B, Punteado+gray);
draw((-2,0) -- C, Punteado+gray);
draw((0,3) -- C, Punteado+gray);
draw((5,0) -- D, Punteado+gray);
draw((0,1) -- D, Punteado+gray);

// Dimensiones de los ejes
real Xmin = -9, Xmax = 6, Ymin = -3, Ymax = 4, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A=$(-8,-2)$"), A, S, 5pt+black);
dot(Label("B=$(1,-3)$"), B, E, 5pt+black);
dot(Label("C=$(-2,3)$"), C, N, 5pt+black);
dot(Label("D=(5,1)"), D, N, 5pt+black);
