//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Resolver el ejercicio 2
// Fecha:    D.28.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Definción de los puntos
pair A=(7,-3), B=(-4,2), C=(2,1), D=(-6,-1);

// Las líneas que indican abscisa y ordenada
pen Punteado = linetype(new real[] {2,2});
draw((7,0) -- A, Punteado+gray);
draw((0,-3) -- A, Punteado+gray);
draw((-4,0) -- B, Punteado+gray);
draw((0,2) -- B, Punteado+gray);
draw((2,0) -- C, Punteado+gray);
draw((0,1) -- C, Punteado+gray);
draw((-6,0) -- D, Punteado+gray);
draw((0,-1) -- D, Punteado+gray);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 8, Ymin = -4, Ymax = 4, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A=$(7,-3)$"), A, S, 5pt+black);
dot(Label("B=$(-4,2)$"), B, N, 5pt+black);
dot(Label("C=(2,1)"), C, N, 5pt+black);
dot(Label("D=$(-6,-1)$"), D, S, 5pt+black);
