//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Ilustrar el enunciado
// Fecha:    V.14.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

//markangle() y markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(-15.5,0), B=(15.5,0), C=(0,14.2);

// El formato de texto
pen Formato=black+fontsize(14pt);

// El triángulo
draw(A -- B -- C -- cycle);

// Los ángulos
markangle(Label("$\alpha$",Formato), radius=10mm, C, B, A, 1bp+blue);
markrightangle(A, C, B, 5mm, 1bp+gray);

// La descripción de los lados
Formato=black+fontsize(12pt);
label("31", (A+B)/2, S, Formato);
label("17", (B+C)/2, NE, Formato);
