//---------------------------------------------------------------
// Fichero:  figura6.asy
// Objetivo: Mostrar la figura 6
// Fecha:    X.19.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(2,0), C=(2,2*sqrt(3));

// El punto auxiliar
pair P=(1,0);

// Los ángulos
pen FormAng=fontsize(12pt)+red;
pen FormArc=0.5bp+red;
markangle(Label("$\alpha$",FormAng), radius=7mm, B, A, C, FormArc);
markrightangle(P, B, C, 2mm, 1bp+gray);

// Los textos
pen FormatoTexto=fontsize(12pt)+deepgreen;
label("$4$", (A+C)/2, NW, FormatoTexto);
label("$\sqrt{13}$", (P+C)/2, S-(-0.25,8), FormatoTexto);

// Dibujamos la figura
draw(A -- B -- C -- A);
draw(C -- P);
