//---------------------------------------------------------------
// Fichero:  figura1.asy
// Objetivo: Mostrar la figura 1
// Fecha:    M.18.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// El punto de abajo en el centro
pair Q=(0,0);

// El vértice de la izquierda
pair A=(-sqrt(3),0);

// El vértice de la derecha
pair B=(3,0);

// El vértice de arriba
pair C=(0,3);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$30^\circ$",FormAng), radius=12mm, A, C, Q, FormArc);
markangle(Label("$45^\circ$",FormAng), radius=10mm, Q, C, B, FormArc);
markrightangle(C, Q, B, 4mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 0.2;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(A+Separacion*(0,-1) -- Q+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(Q+Separacion*(0,-1) -- B+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("$\sqrt{3}$", (A+Q)/2+Separacion*(0,-2), deepgreen+FormatoTexto);
label("x", (Q+B)/2+Separacion*(0,-2), red+FormatoTexto);

// Dibujamos las líneas
draw(Q -- A -- C -- B -- Q -- C);
