//---------------------------------------------------------------
// Fichero:  figura5.asy
// Objetivo: Mostrar la figura 5
// Fecha:    L.17.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// El punto de arriba
pair A=(0,8);

// El punto de la izquierda
pair B=(-8.6,0);

// El punto de la derecha abajo
pair C=(0,0);

// El punto de en medio
pair D=(0,5);

// Los ángulos
pen FormAng=fontsize(8pt)+red;
pen FormArc=0.5bp+red;
markangle(Label("$\alpha$",FormAng),
          radius=8mm, C, B, D, FormArc);
markrightangle(A, C, B, 2mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 0.5;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(A+Separacion*(1,0) -- D+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(D+Separacion*(1,0) -- C+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("3", (A+D)/2+Separacion*(2,0), deepgreen+FormatoTexto);
label("5", (C+D)/2+Separacion*(2,0), deepgreen+FormatoTexto);

// Los nombres de los vértices

dot("A",A,N,3bp+FormatoTexto);
dot("B",B,S,3bp+FormatoTexto);
dot("C",C,S,3bp+FormatoTexto);

// Dibujamos las líneas
draw(D -- B -- A -- C -- B);
