//---------------------------------------------------------------
// Fichero:  enunciado8.asy
// Objetivo: Mostrar la figura del enunciado 8
// Fecha:    V.14.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Los datos del enunciado
int Bas=31, Izq=75, Der=42;

// La rotación
transform R=rotate(65);

// El vértice de la izquierda
pair A=R*(0,0);

// El vértice de la derecha
pair B=R*(Bas,0);

// El vértice de arriba
real x=Bas*Tan(Der)/(Tan(Izq)+Tan(Der));
real h=x*Tan(Izq);
pair C=R*(x,h);

// La proyección de C sobre AB
pair D=R*(x,0);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$"+string(Izq)+"^\circ$",FormAng),
          radius=5mm, D, A, C, FormArc);
markangle(Label("$"+string(Der)+"^\circ$",FormAng),
          radius=10mm, C, B, D, FormArc);

// La separación entre la flecha y la base
real Separacion = 0.5;

// La flecha que marca la base
pen FormatoFlecha=mediumblue+0.5bp;
draw(A+Separacion*(2,-1) -- B+Separacion*(2,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(9pt)+Helvetica(series="b",shape="n");
label("h", (C+D)/2+Separacion*(3,2), red+FormatoTexto);
label(string(Bas), (A+B)/2+Separacion*(4,-3), deepgreen+FormatoTexto);

// Dibujamos el triángulo
draw(A--B--C--A);

// La altura
draw(C -- D, gray);
markrightangle(C, D, B, 2mm, 0.5bp+gray);

// Marcamos los puntos
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
