//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Mostrar la representación del problema
// Fecha:    J.3.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -16, Xmax = 18, Ymin = -11, Ymax = 31, Extra = 0.5;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(step=1, Step=5, NoZero, size=0.25mm, Size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// La circunferencia
draw(circle((6,1),sqrt(130)),blue);

// Los puntos
pair A=(-14,31), T1=(-5,-2), T2=(13,10);

// Las rectas
draw(A -- T1+5*unit(T1-A), deepgreen+1.5bp);
draw(A -- T2+5*unit(T2-A), deepgreen+1.5bp);

// Los puntos
dot(A,blue+6bp);
dot(T1,magenta+3bp);
dot(T2,magenta+3bp);

// Los nombres
label("A",A,W,fontsize(10pt));
label("C",(14,-9),fontsize(10pt));
