//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Resolver el ejercicio 1
// Fecha:    D.28.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Definción de los puntos
pair J=(-5,4), K=(-5,-3), L=(5,1), M=(-3,1);

// Dimensiones de los ejes
real Xmin = -6, Xmax = 6, Ymin = -4, Ymax = 5, Extra = 0.25;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Las líneas
real Sep=0.75;
draw(J+Sep*(0,1) -- K+Sep*(0,-1), black);
draw(M+Sep*(-1,0) -- L+Sep*(1,0), black);
draw(J -- K, 2bp+deepgreen);
draw(M -- L, 2bp+deepgreen);

// Los puntos
FormatoTexto = black+fontsize(8pt);
pen FormatoPunto = 3pt+black;
dot(Label("J",FormatoTexto), J, W, FormatoPunto);
dot(Label("K",FormatoTexto), K, W, FormatoPunto);
dot(Label("L",FormatoTexto), L, N, FormatoPunto);
dot(Label("M",FormatoTexto), M, N, FormatoPunto);
