//---------------------------------------------------------------
// Fichero:  coincidentes.asy
// Objetivo: Representar dos rectas coincidentes
// Fecha:    X.4.6.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.3cm);

// Grosor de las líneas
defaultpen(1);

// Las rectas
pair A=(0,0), B=(10,2);
draw(A -- B);

// Un punto
dot(Label("P"),A+(B-A)/3,N,3bp+black);

// Los nombres de las rectas
label("$r$", B, E);
label("$s$", A, W);
