//---------------------------------------------------------------
// Fichero:  perpendiculares-dentro.asy
// Objetivo: Representar un problema de las rectas perpendiculares
// Fecha:    V.30.5.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El vector de dirección
pair v=(3,2);

// El vector normal
pair n=(-v.y,v.x);

// El punto A
pair A=(0.75,1.5);

// La recta r
pair A1=(0,0), A2=A1+1.2v;
path r1=A1 -- A2;
draw(r1, 1.5bp+blue);
label("r",A2,E,fontsize(12pt));

// La recta s
pair A3=A+0.3n, A4=A-0.45n;
path r2=A3 -- A4;
draw(r2, 1.5bp+deepgreen);
label("s",A4,E,fontsize(12pt));

// El ángulo recto
pair V=intersectionpoint(r1,r2);
markrightangle(A2, V, A3, 4mm, 0.75bp+orange);

// El punto A
dot(V,blue+5bp);
label("A",V,1.75W+0.5N,black+fontsize(12pt));
